﻿/*
 * PhaseShift.c
 *
 * Created: 2014/06/10 19:45:23
 *  Author: Hirosi
 */ 

#include <avr/io.h>
#include "SettingFastPWM.h"

/* アセンブラ関数 プロトタイプ宣言 */
void Inc_TCNT0(uint8_t d);	// 引数 : 1 ... 255
void Inc_TCNT2(uint8_t d);	// 引数 : 1 ... 255
void Reset_TCNT(void);


void PhaseShiftStart()
{
	FastPWMStart();
	OCR0A = 128;
	OCR2A = 128;
	Reset_TCNT();
}


void ShiftSet(uint8_t Shift)
{
	static uint8_t shift_t = 0;
	
	//PORTB |= 0x01;				// オシロで所要時間を計測する時に使用					
	
	if (Shift > shift_t)
	{
		Inc_TCNT0(Shift - shift_t);	// 差分だけTCNT0を増加させる
		shift_t = Shift;			// 設定後の位相差を記憶
	} 
	else if (shift_t > Shift)
	{
		Inc_TCNT2(shift_t - Shift);
		shift_t = Shift;
	}
	
	//PORTB &= ~0x01;
}